import React, { useEffect, useState } from 'react';
import { View, Button } from 'react-native';
import ChildComponent from './ChildComponent';

const ParentComponent = () => {
    const [language, setLanguage] = useState('Java');

    const handleClick = () => {
        console.log('ParentComponent: handleClick called.');
        let newLanguage = language == 'Java' ? 'C' : 'Java';
        setLanguage(newLanguage);
    };
    const updateAndMount = () => {
        console.log('ParentComponent: componentDidMount called.');
        console.log('ParentComponent: componentDidUpdate called.');
    }
    const willUnmount = () => {
        console.log('ParentComponent: componentWillUnmount called.');
    }
    useEffect(
        () => {
            updateAndMount();
            return () => willUnmount();
        });
    return (
        <View style={{ flex: 1, justifyContent: 'center' }}>
            <ChildComponent name={language} />
            <Button onPress={() => handleClick()} title="Change" />
        </View>
    );

}
export default ParentComponent;